library(muxViz)
library(igraph)
library(RColorBrewer)
library(ggraph)
library(Matrix)

set.seed(1)

#Network setup
Layers <- 7
#Layers <- 1
Nodes <- 297


# Read the CSV file into a DataFrame
df <- read.table('multilayer_edgelist_r_int_2018.txt', header = FALSE, sep = " ")
#df <- read.table('migr_edgelist_r_int.txt', header = FALSE, sep = " ")

M <-
  BuildSupraAdjacencyMatrixFromExtendedEdgelist(
  df,
  Layers,
  Nodes,
  isDirected=TRUE
)

# centrality ----------------------------------------------------------------------

page = GetMultiPageRankCentrality(M, Layers, Nodes)
print(page)

#auth = GetMultiAuthCentrality(M, Layers, Nodes)
#print(auth)

#clos = GetMultiClosenessCentrality(M, Layers, Nodes)
#print(clos)

#eig = GetMultiEigenvectorCentrality(M, Layers, Nodes)
#print(eig)

#hub = GetMultiHubCentrality(M, Layers, Nodes)
#print(hub)

#katz = GetMultiKatzCentrality(M, Layers, Nodes)
#print(katz)


# # overlap ----------------------------------------------------------------------
# library(reshape2)
# library(ggplot2)
# library(RColorBrewer)

# #Edge overlapping
# LL.cor1 <- GetAverageGlobalOverlappingMatrix(M,Layers,Nodes)
# LL.cor1.df <- melt(as.matrix(LL.cor1))
# LL.cor1.df$type <- "Edge overlapping"

# #Node overlapping
# LL.cor2 <- GetAverageGlobalNodeOverlappingMatrix(M,Layers,Nodes)
# LL.cor2.df <- melt(as.matrix(LL.cor2))
# LL.cor2.df$type <- "Node overlapping"

# #Assortativity
# LL.cor3 <- GetInterAssortativityTensor(M,Layers,Nodes,T,"TT")$InterPearson
# LL.cor3.df <- melt(as.matrix(LL.cor3))
# LL.cor3.df$type <- "Deg-deg Pearson"

# LL.cor4 <- GetInterAssortativityTensor(M,Layers,Nodes,T,"TT")$InterSpearman
# LL.cor4.df <- melt(as.matrix(LL.cor4))
# LL.cor4.df$type <- "Deg-deg Spearman"

# #Shortest paths
# LL.cor5 <- GetSPSimilarityMatrix(M,Layers,Nodes)
# LL.cor5.df <- melt(as.matrix(LL.cor5))
# LL.cor5.df$type <- "SP similarity"

# LL.cor.df <- rbind(LL.cor1.df, LL.cor2.df, LL.cor3.df, LL.cor4.df, LL.cor5.df)

# p <- ggplot(LL.cor.df, aes(Var1, Var2, fill=value, group=type)) + theme_bw() +
#     theme(panel.grid=element_blank()) + xlab("") + ylab("") +
#     scale_fill_gradientn(colors=brewer.pal(9, "YlOrRd")) +
#     geom_tile() + 
#     facet_wrap(.~type, ncol=2)

# print(p)